library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity HF_TLC_S3 is

port(
	
	F_det: in std_logic;
	reset: in std_logic;
	Clk50: in std_logic;
	
	HG: out std_logic;
	HY: out std_logic;
	HR: out std_logic;
	
	FG: out std_logic;
	FY: out std_logic;
	FR: out std_logic	 );

end HF_TLC_S3;

architecture struct of HF_TLC_S3 is

	component high_farm_tlc 

	port(
	
		C: in std_logic;
		reset: in std_logic;
		Clk: in std_logic;
	
		HG: out std_logic;
		HY: out std_logic;
		HR: out std_logic;
	
		FG: out std_logic;
		FY: out std_logic;
		FR: out std_logic	 );

	end component;

	component clockdiv 
   	port ( CLKin: in std_logic;
      	    CLKout: out std_logic
		);
	end component;

		signal Clk1:std_logic;
	
	
begin
	
	C1: high_farm_tlc port map( C=>F_det, reset=>reset, Clk=>Clk1, HG=>HG, HY=>HY, HR=>HR, FG=>FG, FY=>FY, FR=>FR);
	C2: clockdiv 		  port map( CLKin=>Clk50, CLKout=>Clk1);


end architecture;







