library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity HF_TLC_S3_test is end;

architecture test of HF_TLC_S3_test is

component HF_TLC_S3 is
port(
	F_det: in std_logic;
	reset: in std_logic;
	Clk50: in std_logic;
	
	HG: out std_logic;
	HY: out std_logic;
	HR: out std_logic;
	
	FG: out std_logic;
	FY: out std_logic;
	FR: out std_logic	 );

end component;

signal F_det: std_logic;
signal reset: std_logic;
signal Clk50: std_logic;
	
signal HG: std_logic;
signal HY: std_logic;
signal HR: std_logic;
	
signal FG: std_logic;
signal FY: std_logic;
signal FR: std_logic;

begin

UUT: 	HF_TLC_S3 port map (F_det,	reset, Clk50, 
                          HG,	HY, HR,
								  FG, FY, FR);
	
PCK: process
begin
  Clk50 <= '0', '1' after 10 ns;
  wait for 20 ns;
end process;

reset <='1', '0' after 20 ns;

PFDET: process
begin
  F_det<='0';
  wait for 10 sec;
  F_det<='1';
  wait;
end process;

end architecture;







