library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity high_farm_tlc is

port(

	C: in std_logic;
	reset: in std_logic;
	Clk: in std_logic;
	
	HG: out std_logic;
	HY: out std_logic;
	HR: out std_logic;
	
	FG: out std_logic;
	FY: out std_logic;
	FR: out std_logic	 );

end high_farm_tlc;

architecture behavioral of high_farm_tlc is

	type stare is (HGreen,HYellow,FYellow,FGreen);


	signal TS: std_logic;
	signal TLH: std_logic; 
	signal TLF: std_logic;
	
	signal ST: std_logic;    

-- semnale pentru simulare
	signal sstate: stare;
	signal scount: integer range 0 to integer'high;

begin

FSM_TLC: process(CLK, reset)

    variable state: stare:=HGreen;

  begin
	if(reset='1') then 
		state:= HGreen;

	elsif CLK'event and CLK='1' then 
  	      ST <= '0';	
  	      
  	      case state is
  	        when HGreen =>
  	           HG<='1'; HY<='0'; HR <='0';
		   FG<='0'; FY<='0'; FR <='1';
  	           
  	           if TLH='1' and C='1' then
  	              state := HYellow;
  	              ST <= '1';
  	           end if;
		when HYellow =>
  	           HG<='0'; HY<='1'; HR <='0';
		   FG<='0'; FY<='0'; FR <='1';

  	           if TS='1' then
  	              state := FGreen;
  	              ST <= '1';
  	           end if;
  	        when FGreen =>
  	           HG<='0'; HY<='0'; HR <='1';
		   FG<='1'; FY<='0'; FR <='0';

  	           if TLF='1' or C='0' then
  	              state := FYellow;
  	              ST <= '1';
  	           end if;
  	        when FYellow =>
  	           HG<='0'; HY<='0'; HR <='1';
		   FG<='0'; FY<='1'; FR <='0';
  	        
  	        
  	           if TS='1' then
  	              state := HGreen;
  	              ST <= '1';
  	           end if;
  	      end case;

	end if;
 	sstate <= state;
  end process;

  timer:process (clk,ST)
     variable count: integer range 0 to integer'high;
  begin
     if ST='1' then
         count:=0;
     elsif CLK'event and CLK='1' then
        count:= count + 1;
     end if;
     
     if count>=4 then
        TS<='1';
     else
        TS<='0';
     end if;
     
     if count>=14 then
        TLF<='1';
     else
        TLF<='0';
     end if;

     if count>=24 then
        TLH<='1';
     else
        TLH<='0';
     end if;
     scount <=count;
  end process; 


end behavioral;












